/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import enseeiht.kl2.tobias.Arme;
import enseeiht.kl2.tobias.InteractionsLogiques;
import enseeiht.kl2.tobias.Inventaire;
import enseeiht.kl2.tobias.TexturedHitBox;
import enseeiht.kl2.tobias.Utils;

public abstract class Vivant
extends TexturedHitBox
implements InteractionsLogiques {
    public static final float SPEED_FACTOR = 5.0f * (float)Gdx.graphics.getWidth() / 1080.0f;
    private final String nom;
    private final Vector2 direction;
    private final Inventaire inventaire = new Inventaire();
    private Arme offensif;
    private Arme defensif;
    private int hp;
    private final int maxHp;
    private float vitesse;
    private boolean mort = false;
    private boolean godMode = false;
    private int niveau = 1;

    public Vivant(String nom, String texture, Vector2 direction, int baseHP) {
        this(nom, texture, 0.0f, 0.0f, direction, Arme.aleatoire(), Arme.aleatoire(), baseHP, 20.0f);
    }

    public Vivant(String nom, String texture, float x, float y, Vector2 direction, Arme offensif, Arme defensif, int baseHP, float vitesse) {
        super(texture.isBlank() ? null : new Texture(texture), x, y);
        this.nom = nom;
        this.direction = direction;
        this.offensif = offensif.setProprietaire(this);
        this.defensif = defensif.setProprietaire(this);
        this.hp = baseHP;
        this.maxHp = baseHP;
        this.setVitesse(vitesse);
    }

    public Inventaire getInventaire() {
        return this.inventaire;
    }

    public void ramasser(Inventaire inventaire) {
        inventaire.ramasser(inventaire);
    }

    public int getMaxHp() {
        return this.maxHp;
    }

    public int getHp() {
        return this.hp;
    }

    public float reduireHP(float degats) {
        float degatsEffectifs = 0.0f;
        if (!this.godMode) {
            degatsEffectifs = this.defensif.parer(degats);
            this.hp -= MathUtils.floor(degatsEffectifs);
            if (this.hp <= 0) {
                this.mourir();
            }
        }
        return degatsEffectifs;
    }

    public void soigner(int soins) {
        if (this.mort) {
            return;
        }
        int soinsEffectifs = Math.min(soins, this.maxHp - this.hp);
        this.hp += soinsEffectifs;
    }

    @Override
    public boolean overlaps(Rectangle autre) {
        return this.defensif.overlaps(autre);
    }

    public Arme getOffensif() {
        return this.offensif;
    }

    public Arme getDefensif() {
        return this.defensif;
    }

    public void setOffensif(Arme offensif) {
        this.offensif = offensif;
    }

    public void setDefensif(Arme defensif) {
        this.defensif = defensif;
    }

    public boolean getGodMode() {
        return this.godMode;
    }

    public void setGodMode(boolean godMode) {
        this.godMode = godMode;
    }

    public void setDirection(float x, float y) {
        this.direction.set(x, y).nor();
    }

    public void setVitesse(float vitesse) {
        this.vitesse = vitesse * SPEED_FACTOR;
    }

    public int getNiveau() {
        return this.niveau;
    }

    public void niveauSuperieur() {
        ++this.niveau;
        this.offensif.setModificateurDegats(this.getModificateurDegats());
        this.defensif.setModificateurProtection(this.getModificateurProtection());
    }

    public float getModificateurDegats() {
        return this.niveau;
    }

    public float getModificateurProtection() {
        return this.niveau;
    }

    @Override
    public void translate(float x, float y) {
        super.translate(x, y);
        this.defensif.setHitbox(this.hitbox);
    }

    public void avancer() {
        this.direction.nor();
        float delta = Gdx.graphics.getDeltaTime();
        this.translate(this.direction.x * this.vitesse * delta, this.direction.y * this.vitesse * delta);
    }

    public void avancer(float x, float y) {
        this.setDirection(x, y);
        this.avancer();
    }

    public void avancerVers(float x, float y) {
        this.avancer(x - this.getX() - this.getWidth() / 2.0f, y - this.getY() - this.getHeight() / 2.0f);
    }

    public void avancerVers(Vector2 coordonnees) {
        this.avancerVers(coordonnees.x, coordonnees.y);
    }

    public void avancerVers(TexturedHitBox autre) {
        this.avancerVers(autre.getX(), autre.getY());
    }

    public void setAttaqueHitbox(float x, float y) {
        this.setDirection(x - this.getX(), y - this.getY());
        this.offensif.setHitbox(this.hitbox);
        this.offensif.setHitboxCenter(this.hitbox.getCenter(Utils.VECTEUR1).add(this.direction.scl(this.offensif.getPortee())));
    }

    public void setAttaqueHitbox(Vector2 direction) {
        this.setAttaqueHitbox(direction.x, direction.y);
    }

    public void setAttaqueHitbox(TexturedHitBox autre) {
        this.setAttaqueHitbox(autre.getX(), autre.getY());
    }

    public float attaquer(Vivant autre) {
        return this.offensif.attaquer(autre);
    }

    @Override
    public void logic() {
        this.deplacements();
        this.collisions();
    }

    @Override
    public void draw(Batch batch) {
        this.draw(batch, true);
    }

    protected void draw(Batch batch, boolean afficherHP) {
        if (!this.mort) {
            super.draw(batch);
            if (afficherHP) {
                Utils.graphisme.dessinerBarreDeVie(this);
            }
        }
    }

    protected void mourir() {
        this.mort = true;
        Utils.jeu.getEtageActuel().getSalleActuelle().getVivants().removeValue(this, false);
        Utils.jeu.getEtageActuel().getSalleActuelle().setCompletee();
    }
}

