/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Array;
import enseeiht.kl2.tobias.Animation;
import enseeiht.kl2.tobias.Utils;

public abstract class TexturedHitBox
extends Sprite {
    public static final float CORRECTION_FACTOR = 1.0f;
    protected final Rectangle hitbox;
    private final Animation animation = new Animation();
    private float scaleX;
    private float scaleY;

    public TexturedHitBox(Texture texture, float x, float y) {
        this(texture, x, y, 0.0f, 0.0f);
    }

    public TexturedHitBox(Texture texture, float x, float y, float width, float height) {
        if (texture != null) {
            this.animation.ajouterTexture(texture);
        }
        this.hitbox = new Rectangle(x, y, width, height);
        this.setPosition(x, y);
        this.setScale(width, height);
    }

    @Override
    public float getWidth() {
        return this.hitbox.width;
    }

    @Override
    public float getHeight() {
        return this.hitbox.height;
    }

    @Override
    public Texture getTexture() {
        return this.animation.getTexture();
    }

    public Rectangle getHitbox() {
        return this.hitbox;
    }

    @Override
    public void setScale(float scaleX, float scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    @Override
    public void setScale(float scaleXY) {
        this.setScale(scaleXY, scaleXY);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX = Math.max(scaleX, (float)this.getTexture().getWidth());
        this.hitbox.setWidth(scaleX);
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY = Math.max(scaleY, (float)this.getTexture().getHeight());
        this.hitbox.setHeight(scaleY);
    }

    public boolean overlaps(Rectangle other) {
        return this.hitbox.overlaps(other);
    }

    public boolean overlaps(TexturedHitBox other) {
        return this.overlaps(other.getHitbox());
    }

    public void collisions() {
        this.collisions(1.0f);
    }

    public void collisions(float facteurCorrection) {
        Vector4 dimensions = Utils.jeu.getEtageActuel().getSalleActuelle().getDimensions();
        float xMin = dimensions.x;
        float yMin = dimensions.y;
        float xMax = dimensions.z;
        float yMax = dimensions.w;
        this.setX(MathUtils.clamp(this.getX(), xMin, xMax));
        this.setY(MathUtils.clamp(this.getY(), yMin, yMax));
        Array<TexturedHitBox> obstacles = Utils.jeu.getEtageActuel().getSalleActuelle().getObstacles();
        Vector2 collisionsResultantes = Utils.VECTEUR1.set(0.0f, 0.0f);
        for (int i = 0; i < obstacles.size; ++i) {
            TexturedHitBox obstacle = obstacles.get(i);
            collisionsResultantes.add(this.eviter(obstacle, Utils.VECTEUR2));
        }
        this.appliquerCorrectif(collisionsResultantes.x, collisionsResultantes.y, facteurCorrection);
    }

    public void eviter(TexturedHitBox autre, float facteurCorrection) {
        Vector2 collisions = this.eviter(autre, Utils.VECTEUR1);
        this.appliquerCorrectif(collisions.x, collisions.y, facteurCorrection);
    }

    public Vector2 eviter(TexturedHitBox autre, Vector2 collisions) {
        if (this.overlaps(autre)) {
            float overlapX = Math.min(this.getX() + this.getWidth() - autre.getX(), autre.getX() + autre.getWidth() - this.getX());
            float overlapY = Math.min(this.getY() + this.getHeight() - autre.getY(), autre.getY() + autre.getHeight() - this.getY());
            float collisionX = 0.0f;
            float collisionY = 0.0f;
            if (overlapX < overlapY) {
                collisionX = this.getX() < autre.getX() ? -overlapX : overlapX;
            } else {
                collisionY = this.getY() < autre.getY() ? -overlapY : overlapY;
            }
            return collisions.set(collisionX, collisionY);
        }
        return collisions.setZero();
    }

    private void appliquerCorrectif(float collisionX, float collisionY, float facteurCorrection) {
        this.translate(facteurCorrection * collisionX, facteurCorrection * collisionY);
    }

    @Override
    public void setPosition(float x, float y) {
        super.setPosition(x, y);
        this.hitbox.setPosition(x, y);
    }

    public void setPosition(Vector2 position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setX(float x) {
        super.setX(x);
        this.hitbox.setX(x);
    }

    @Override
    public void setY(float y) {
        super.setY(y);
        this.hitbox.setY(y);
    }

    @Override
    public void translate(float x, float y) {
        super.translate(x, y);
        this.hitbox.setPosition(this.getX(), this.getY());
    }

    @Override
    public void draw(Batch batch) {
        batch.draw(this.getTexture(), this.getX(), this.getY(), this.scaleX, this.scaleY);
    }

    public void dispose() {
        this.animation.dispose();
    }

    public void setAnimationFrequence(int frequence) {
        this.animation.setFrequence(frequence);
    }

    public void ajouterTextures(String ... paths) {
        boolean scale = this.animation.getNombreTextures() == 0;
        this.animation.ajouterTextures(paths);
        if (scale) {
            Texture texture = this.animation.getTexture();
            this.setScale(texture.getWidth(), texture.getHeight());
        }
    }
}

