/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import enseeiht.kl2.tobias.Ecrans;

public class SettingsScreen
implements Screen {
    private final Game game;
    private Stage stage;
    private Skin skin;
    private Screen backScreen;

    public SettingsScreen(Game game, Screen backScreen) {
        this.game = game;
        this.backScreen = backScreen;
    }

    @Override
    public void show() {
        this.stage = new Stage(new ScreenViewport());
        Gdx.input.setInputProcessor(this.stage);
        this.skin = new Skin(Gdx.files.internal("plain-james-ui.json"));
        Table table = new Table();
        table.setFillParent(true);
        table.center();
        Label titleLabel = new Label("Parametres", this.skin, "title");
        table.add(titleLabel).padBottom(40.0f);
        table.row();
        TextButton playButton = new TextButton("Jouer", this.skin);
        playButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Ecrans.gestionnaire.reprendre();
            }
        });
        table.add(playButton).padBottom(20.0f).width(200.0f).height(50.0f);
        table.row();
        TextButton quitButton = new TextButton("Quitter", this.skin);
        quitButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                Gdx.app.exit();
            }
        });
        table.add(quitButton).width(200.0f).height(50.0f);
        this.stage.addActor(table);
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.stage.act(delta);
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.getViewport().update(width, height, true);
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void dispose() {
        this.stage.dispose();
        this.skin.dispose();
    }
}

