/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector4;
import com.badlogic.gdx.utils.Array;
import enseeiht.kl2.tobias.Coffre;
import enseeiht.kl2.tobias.Decor;
import enseeiht.kl2.tobias.Disposition;
import enseeiht.kl2.tobias.Ennemi;
import enseeiht.kl2.tobias.Mur;
import enseeiht.kl2.tobias.Piece;
import enseeiht.kl2.tobias.Porte;
import enseeiht.kl2.tobias.TexturedHitBox;
import enseeiht.kl2.tobias.Utils;
import enseeiht.kl2.tobias.Vivant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Salle {
    private int[][] disposition = Disposition.getDisposition();
    private final Map<Float, Array<Float>> spawnsValides = new HashMap<Float, Array<Float>>();
    private List<Float> spawnsX;
    protected Coffre coffre;
    protected final Array<Piece> pieces = new Array();
    protected final Array<TexturedHitBox> obstacles = new Array();
    protected final Array<Vivant> vivants = new Array();
    protected final Array<Porte> portes = new Array();
    private static final Vector4 dimensions = new Vector4();
    private Salle nord = null;
    private Salle sud = null;
    private Salle est = null;
    private Salle ouest = null;
    private float xMin = 0.0f;
    private float yMin = 120.0f;
    private float xMax;
    private float yMax;
    private float pasX;
    private float pasY;
    protected boolean decorsGeneres = false;
    protected boolean ennemisGeneres = false;
    protected boolean completee = false;

    public Salle(float worldWidth, float worldHeight) {
        this.xMax = worldWidth;
        this.yMax = worldHeight;
    }

    public Array<TexturedHitBox> getObstacles() {
        return this.obstacles;
    }

    public Array<Vivant> getVivants() {
        return this.vivants;
    }

    public Array<Porte> getPortes() {
        return this.portes;
    }

    public Coffre getCoffre() {
        return this.coffre;
    }

    public Vector4 getDimensions() {
        return dimensions.set(this.xMin, this.yMin, this.xMax, this.yMax);
    }

    public Vector2 getPas() {
        return this.getPas(Utils.VECTEUR1);
    }

    public Vector2 getPas(Vector2 vecteur) {
        return vecteur.set(this.pasX, this.pasY);
    }

    public Salle getSalle(Direction direction) {
        switch (direction.ordinal()) {
            case 0: {
                return this.nord;
            }
            case 1: {
                return this.sud;
            }
            case 2: {
                return this.est;
            }
            case 3: {
                return this.ouest;
            }
        }
        throw new IllegalArgumentException("Direction inconnue : " + String.valueOf((Object)direction));
    }

    public void setSalle(Direction direction, Salle salle) {
        switch (direction.ordinal()) {
            case 0: {
                this.nord = salle;
                break;
            }
            case 1: {
                this.sud = salle;
                break;
            }
            case 2: {
                this.est = salle;
                break;
            }
            case 3: {
                this.ouest = salle;
                break;
            }
            default: {
                throw new IllegalArgumentException("Direction inconnue : " + String.valueOf((Object)direction));
            }
        }
    }

    public static Direction oppose(Direction direction) {
        switch (direction.ordinal()) {
            case 0: {
                return Direction.SUD;
            }
            case 1: {
                return Direction.NORD;
            }
            case 2: {
                return Direction.OUEST;
            }
            case 3: {
                return Direction.EST;
            }
        }
        throw new IllegalArgumentException("Direction inconnue : " + String.valueOf((Object)direction));
    }

    public boolean estCompletee() {
        return this.completee;
    }

    protected void genererDecor() {
        Texture decor = new Texture("mur.png");
        Texture mur = new Texture("mur.png");
        Texture porte = new Texture("porte.png");
        int nbMursDirection = 2;
        this.pasX = (this.xMax - this.xMin) / (float)(this.disposition[0].length + 2);
        this.pasY = (this.yMax - this.yMin) / (float)(this.disposition.length + 2);
        this.obstacles.add(new Mur(mur, this.xMin, this.yMin, this.xMax, this.pasY));
        this.obstacles.add(new Mur(mur, this.xMin, this.yMax - this.pasY, this.xMax, this.pasY));
        this.obstacles.add(new Mur(mur, this.xMax - this.pasX, this.yMin, this.pasX, this.yMax));
        this.obstacles.add(new Mur(mur, this.xMin, this.yMin, this.pasX, this.yMax));
        this.xMin += this.pasX;
        this.yMin += this.pasY;
        this.xMax -= this.pasX;
        this.yMax -= this.pasY;
        for (int i = 0; i < this.disposition.length; ++i) {
            for (int j = 0; j < this.disposition[i].length; ++j) {
                float x = this.xMin + (float)j * this.pasX;
                float y = this.yMax - (float)(i + 1) * this.pasY;
                if (this.disposition[i][j] == 1) {
                    this.obstacles.add(new Decor(decor, x, y, this.pasX, this.pasY));
                    continue;
                }
                if (!this.spawnsValides.containsKey(Float.valueOf(x))) {
                    this.spawnsValides.put(Float.valueOf(x), new Array());
                }
                this.spawnsValides.get(Float.valueOf(x)).add(Float.valueOf(y));
            }
        }
        if (this.nord != null) {
            this.portes.add(new Porte(porte, (this.xMin + this.xMax - this.pasX) / 2.0f, this.yMax, this.pasX, this.pasY, this, Direction.NORD));
        }
        if (this.sud != null) {
            this.portes.add(new Porte(porte, (this.xMin + this.xMax - this.pasX) / 2.0f, this.yMin - this.pasY, this.pasX, this.pasY, this, Direction.SUD));
        }
        if (this.est != null) {
            this.portes.add(new Porte(porte, this.xMax, (this.yMin + this.yMax - this.pasY) / 2.0f, this.pasX, this.pasY, this, Direction.EST));
        }
        if (this.ouest != null) {
            this.portes.add(new Porte(porte, this.xMin - this.pasX, (this.yMin + this.yMax - this.pasY) / 2.0f, this.pasX, this.pasY, this, Direction.OUEST));
        }
        this.setCoffre(new Coffre((this.xMin + this.xMax - this.pasX) / 2.0f, (this.yMin + this.yMax - this.pasY) / 2.0f));
        this.spawnsX = new ArrayList<Float>(this.spawnsValides.keySet());
        this.decorsGeneres = true;
    }

    public void genererEnnemis() {
        if (!this.ennemisGeneres) {
            if (!this.decorsGeneres) {
                this.genererDecor();
            }
            if (!this.completee) {
                int maxEnnemis = 5;
                int nbEnnemis = MathUtils.random(1, maxEnnemis);
                for (int i = 0; i < nbEnnemis; ++i) {
                    Ennemi ennemi = new Ennemi("Ennemi", "mob2.png", Utils.VECTEUR2, 100);
                    this.ajouter(ennemi);
                    float x = this.spawnsX.get(MathUtils.random(this.spawnsX.size() - 1)).floatValue();
                    float y = this.spawnsValides.get(Float.valueOf(x)).get(MathUtils.random(this.spawnsValides.get((Object)Float.valueOf((float)x)).size - 1)).floatValue();
                    ennemi.setPosition(x, y);
                }
            }
            this.ennemisGeneres = true;
        }
    }

    public void logic() {
        int i;
        if (!this.ennemisGeneres) {
            this.genererEnnemis();
        }
        for (i = 0; i < this.vivants.size; ++i) {
            this.vivants.get(i).logic();
        }
        for (i = this.pieces.size - 1; i >= 0; --i) {
            if (!this.pieces.get(i).collecte(Utils.player)) continue;
            this.pieces.removeIndex(i);
        }
    }

    public void draw(Batch batch) {
        int i;
        for (i = 0; i < this.obstacles.size; ++i) {
            this.obstacles.get(i).draw(batch);
        }
        if (this.completee) {
            this.coffre.draw(batch);
            for (i = 0; i < this.portes.size; ++i) {
                this.portes.get(i).draw(batch);
            }
        }
        for (i = 0; i < this.vivants.size; ++i) {
            this.vivants.get(i).draw(batch);
        }
        for (i = 0; i < this.pieces.size; ++i) {
            this.pieces.get(i).draw(batch);
        }
    }

    public void ajouter(Vivant vivant) {
        if (vivant != null) {
            this.vivants.add(vivant);
            this.scale(vivant);
        }
    }

    public void scale(TexturedHitBox autre) {
        if (autre != null) {
            autre.setScale(this.pasX, this.pasY);
        }
    }

    public void setCompletee() {
        if (!this.ennemisGeneres) {
            this.genererEnnemis();
        }
        this.completee = this.vivants.size == 0;
    }

    public void spawnPiece(Piece p) {
        this.pieces.add(p);
    }

    public void dispose() {
        int i;
        for (i = 0; i < this.obstacles.size; ++i) {
            this.obstacles.get(i).dispose();
        }
        for (i = 0; i < this.vivants.size; ++i) {
            this.vivants.get(i).dispose();
        }
        for (i = 0; i < this.portes.size; ++i) {
            this.portes.get(i).dispose();
        }
        for (i = 0; i < this.pieces.size; ++i) {
            this.pieces.get(i).dispose();
        }
    }

    public void setDisposition(int[][] disposition) {
        this.disposition = disposition;
    }

    public void setCoffre(Coffre coffre) {
        this.coffre = coffre;
        this.scale(coffre);
    }

    public Salle regenerer() {
        this.decorsGeneres = false;
        this.ennemisGeneres = false;
        this.completee = false;
        this.nord = null;
        this.sud = null;
        this.est = null;
        this.ouest = null;
        this.obstacles.clear();
        this.vivants.clear();
        this.portes.clear();
        this.pieces.clear();
        this.coffre = null;
        this.spawnsValides.clear();
        this.spawnsX = null;
        return this;
    }

    public void ajouter(Porte porte) {
        this.portes.add(porte);
        this.scale(porte);
    }

    public Vector2 coordonneesSpawn(Direction direction) {
        return this.coordonneesSpawn(direction, Utils.VECTEUR2);
    }

    public Vector2 coordonneesSpawn(Direction direction, Vector2 coordonnees) {
        float x = 0.0f;
        float y = 0.0f;
        switch (direction.ordinal()) {
            case 0: {
                x = (this.xMin + this.xMax - this.pasX) / 2.0f;
                y = this.yMax - this.pasY;
                break;
            }
            case 1: {
                x = (this.xMin + this.xMax - this.pasX) / 2.0f;
                y = this.yMin;
                break;
            }
            case 2: {
                x = this.xMax - this.pasX;
                y = (this.yMin + this.yMax - this.pasY) / 2.0f;
                break;
            }
            case 3: {
                x = this.xMin;
                y = (this.yMin + this.yMax - this.pasY) / 2.0f;
            }
        }
        return coordonnees.set(x, y);
    }

    public static enum Direction {
        NORD,
        SUD,
        EST,
        OUEST;

    }
}

