/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import enseeiht.kl2.tobias.Arme;
import enseeiht.kl2.tobias.Coffre;
import enseeiht.kl2.tobias.Ecrans;
import enseeiht.kl2.tobias.Etage;
import enseeiht.kl2.tobias.Graphisme;
import enseeiht.kl2.tobias.Porte;
import enseeiht.kl2.tobias.Salle;
import enseeiht.kl2.tobias.UI;
import enseeiht.kl2.tobias.Utils;
import enseeiht.kl2.tobias.Vivant;

public class Player
extends Vivant {
    private final InputProcessor inputs = new InputAdapter(){

        @Override
        public boolean keyTyped(char character) {
            return Player.this.getInventaire().utiliser("&\u00e9\"'(-\u00e8_\u00e7\u00e0".indexOf(character), Player.this);
        }

        @Override
        public boolean keyDown(int keycode) {
            switch (keycode) {
                case 111: {
                    Ecrans.gestionnaire.pause();
                    return true;
                }
                case 52: {
                    Coffre coffre = Utils.jeu.getEtageActuel().getSalleActuelle().getCoffre();
                    Array<Porte> portes = Utils.jeu.getEtageActuel().getSalleActuelle().getPortes();
                    boolean finBoucle = false;
                    for (int i = 0; i < portes.size && !finBoucle; ++i) {
                        finBoucle = portes.get(i).ouvrir();
                    }
                    if (coffre != null) {
                        coffre.ouvrir(Player.this);
                    }
                    return true;
                }
                case 131: {
                    Player.this.setGodMode(!Player.this.getGodMode());
                    return true;
                }
                case 38: {
                    Player.this.getInventaire().jeter();
                    return true;
                }
            }
            return false;
        }
    };
    private int pieces = 0;

    public Player() {
        super("TOBias", "", 0.0f, 0.0f, new Vector2(), Arme.aucune, Arme.aucune, 100, 40.0f);
        Gdx.input.setInputProcessor(this.inputs);
        this.setAnimationFrequence(100);
        this.ajouterTextures("TOBias_idle1.png", "TOBias_walk1.png", "TOBias_walk3.png");
    }

    public InputProcessor getInputs() {
        return this.inputs;
    }

    @Override
    public void deplacements() {
        if (Gdx.input.isButtonPressed(1)) {
            this.avancerVers(Utils.positionSouris());
        } else {
            float x = 0.0f;
            float y = 0.0f;
            if (Gdx.input.isKeyPressed(21) || Gdx.input.isKeyPressed(45) || Gdx.input.isKeyPressed(29)) {
                x -= 1.0f;
            }
            if (Gdx.input.isKeyPressed(22) || Gdx.input.isKeyPressed(32)) {
                x += 1.0f;
            }
            if (Gdx.input.isKeyPressed(19) || Gdx.input.isKeyPressed(54) || Gdx.input.isKeyPressed(51)) {
                y += 1.0f;
            }
            if (Gdx.input.isKeyPressed(20) || Gdx.input.isKeyPressed(47)) {
                y -= 1.0f;
            }
            if (x != 0.0f || y != 0.0f) {
                this.avancer(x, y);
            }
        }
    }

    public int attaquer() {
        float degatsTotaux = 0.0f;
        if (Gdx.input.isButtonJustPressed(0)) {
            this.setAttaqueHitbox(Utils.positionSouris());
            Array<Vivant> vivants = Utils.jeu.getEtageActuel().getSalleActuelle().getVivants();
            for (int i = 0; i < vivants.size; ++i) {
                Vivant vivant = vivants.get(i);
                if (this.equals(vivant)) continue;
                degatsTotaux += this.attaquer(vivant);
            }
        }
        return MathUtils.floor(degatsTotaux);
    }

    @Override
    public void logic() {
        super.logic();
        this.attaquer();
    }

    @Override
    protected void mourir() {
        super.mourir();
        Ecrans.gestionnaire.menuPrincipal();
    }

    public void entrerSalle(Salle.Direction direction) {
        Etage etage = Utils.jeu.getEtageActuel();
        etage.setSalleActuelle(direction);
        Salle salle = etage.getSalleActuelle();
        salle.scale(this);
        this.setPosition(salle.coordonneesSpawn(Salle.oppose(direction)));
    }

    @Override
    public void draw(Batch batch) {
        super.draw(batch, false);
        this.getInventaire().draw(batch);
        Utils.graphisme.dessinerBarreDeVie(this.getHp(), this.getMaxHp(), 10.0f, 10.0f, UI.widthHP, UI.heightHP);
        Utils.graphisme.ecrire(batch, this.getHp() + " / " + this.getMaxHp(), 10.0f, 10.0f + UI.heightHP, Graphisme.getFontSize(3.0f), Color.RED);
        Utils.graphisme.ecrire(batch, this.pieces + " pi\u00e8ces\nNiveau " + this.getNiveau() + "\n" + String.valueOf(this.getOffensif()) + "\n" + String.valueOf(this.getDefensif()), UI.xMinInfos, 0.0f + UI.heigthInfos);
    }

    public void addPieces(int nb) {
        int palier = 3;
        int ancien = this.pieces % palier;
        this.pieces += nb;
        for (int i = 0; i < (nb + ancien) / palier; ++i) {
            this.niveauSuperieur();
        }
    }
}

