/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import enseeiht.kl2.tobias.Consomable;
import enseeiht.kl2.tobias.Graphisme;
import enseeiht.kl2.tobias.UI;
import enseeiht.kl2.tobias.Utils;
import enseeiht.kl2.tobias.Vivant;
import java.util.Arrays;

public class Inventaire {
    public static final int TAILLE_MAX = 10;
    private final Consomable[] contenu = new Consomable[10];
    private final float xMin = UI.xMinInv;
    private final float xMax = UI.xMaxInv;
    private final float yMin = 10.0f;
    private final float height;
    private final Vide vide = new Vide();
    private int curseur = -1;
    private int indiceVide = 0;

    public Inventaire() {
        Arrays.fill(this.contenu, null);
        float xOptimal = 10.0f * (this.vide.getWidth() + 10.0f);
        float ratio = (this.xMax - this.xMin) / xOptimal;
        this.height = Math.min(UI.heightInv, this.vide.getHeight() * ratio);
        float diffHeight = (UI.heightInv - this.height) / 2.0f;
        if (diffHeight < 0.0f) {
            UI.updateHeight(diffHeight);
        }
    }

    public void supprimer(int i) {
        if (0 <= i && i < this.contenu.length) {
            this.contenu[i] = null;
            this.indiceVide = Math.min(this.indiceVide, i);
        }
    }

    public void ramasser(Consomable item) {
        if (item == null || this.placesVides() == 0) {
            return;
        }
        this.contenu[this.indiceVide++] = item;
        for (int i = this.contenu.length - 1; i >= 0; --i) {
            if (this.contenu[i] != null) continue;
            this.indiceVide = i;
        }
    }

    public boolean ramasser(Inventaire inventaire) {
        if (inventaire == null || inventaire.placesVides() < this.placesUtilisees()) {
            return false;
        }
        for (Consomable item : inventaire.contenu) {
            if (item == null) continue;
            this.ramasser(item);
        }
        return true;
    }

    public boolean positionnerCurseur(int indice) {
        if (0 <= indice && indice < this.contenu.length) {
            if (this.curseur == indice) {
                return true;
            }
            this.curseur = indice;
        }
        return false;
    }

    public boolean utiliser(int position, Vivant vivant) {
        if (this.positionnerCurseur(position) && this.contenu[position] != null) {
            this.contenu[position].utiliser(vivant);
            this.supprimer(position);
            return true;
        }
        return false;
    }

    public void jeter() {
        this.supprimer(this.curseur);
    }

    public void draw(Batch batch) {
        float x = this.xMin;
        for (int i = 0; i < this.contenu.length; ++i) {
            Consomable item = this.contenu[i];
            this.draw(this.vide.setIndice(i), x, 10.0f, this.height, batch);
            if (item != null) {
                float xItem = x + (this.vide.getWidth() - item.getWidth()) / 2.0f;
                float yItem = 20.0f;
                float heightItem = this.height - 20.0f;
                this.draw(item, xItem, yItem, heightItem, batch);
            }
            Utils.graphisme.ecrire("" + (i + 1) % 10, x + this.vide.getWidth() / 2.0f, 10.0f + this.height - 10.0f);
            x += this.vide.getWidth() + 10.0f;
        }
        x = this.xMin;
        for (Consomable item : this.contenu) {
            if (item != null) {
                Utils.graphisme.ecrire(item.affichageInventaire(), x, 10.0f + (float)Graphisme.getFontSize());
            }
            x += this.vide.getWidth() + 10.0f;
        }
    }

    public void draw(Consomable item, float x, float y, float height, Batch batch) {
        if (item != null) {
            Texture texture = item.getTexture();
            float ratio = (float)texture.getWidth() / (float)texture.getHeight();
            float width = height * ratio;
            item.setSize(width, height);
            item.setPosition(x, y);
            batch.draw(texture, x, y, width, height);
        }
    }

    public int placesVides() {
        int count = 0;
        for (Consomable item : this.contenu) {
            if (item != null) continue;
            ++count;
        }
        return count;
    }

    public int placesUtilisees() {
        return this.contenu.length - this.placesVides();
    }

    private class Vide
    extends Consomable {
        private int indice;
        private final Texture[] textures;

        public Vide() {
            super(new Texture("case_inventaire.png"));
            this.textures = new Texture[]{new Texture("case_inventaire.png"), new Texture("case_inventaire_select.png")};
        }

        @Override
        public void utiliser(Vivant vivant) {
        }

        public Consomable setIndice(int indice) {
            this.indice = indice;
            return this;
        }

        @Override
        public Texture getTexture() {
            return this.textures[Inventaire.this.curseur == this.indice ? 1 : 0];
        }
    }
}

