/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import enseeiht.kl2.tobias.Vivant;

public class Graphisme {
    public static final float OFFSET = 10.0f;
    private static final int FONT_SIZE = 15;
    private static final float FONT_MULT = 2.0f * (float)Gdx.graphics.getHeight() / 1800.0f;
    private final ShapeRenderer shapeRenderer = new ShapeRenderer();
    private final BitmapFont font = new BitmapFont();
    private Batch batch;
    private float x;
    private float y;
    private float longueur;
    private float hauteur;

    public Graphisme() {
        this(60.0f, 1000.0f, 400.0f, 60.0f);
    }

    public Graphisme(float x, float y, float longueur, float hauteur) {
        this.x = x;
        this.y = y;
        this.longueur = longueur;
        this.hauteur = hauteur;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setLongueur(float longueur) {
        this.longueur = longueur;
    }

    public void setHauteur(float hauteur) {
        this.hauteur = hauteur;
    }

    public void begin(Batch batch) {
        batch.begin();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.batch = batch;
    }

    public void end() {
        this.shapeRenderer.end();
        this.batch.end();
    }

    public void dessinerBarreDeVie(int currentHp, int maxHp, float x, float y, float longueur, float hauteur) {
        float pourcentageVie = Math.max((float)currentHp, 0.0f) / (float)maxHp;
        float longueurVie = longueur * pourcentageVie;
        this.shapeRenderer.setColor(Color.RED);
        this.shapeRenderer.rect(x, y, longueur, hauteur);
        this.shapeRenderer.setColor(Color.GREEN);
        this.shapeRenderer.rect(x, y, longueurVie, hauteur);
    }

    public void dessinerBarreDeVie(Vivant vivant) {
        if (vivant != null) {
            float xOffset = vivant.getWidth() / 10.0f;
            this.dessinerBarreDeVie(vivant.getHp(), vivant.getMaxHp(), vivant.getX() - xOffset, vivant.getY() + vivant.getHeight() + 10.0f, vivant.getWidth() + xOffset * 2.0f, 10.0f);
        }
    }

    public void ecrire(String texte, float x, float y) {
        this.ecrire(this.batch, texte, x, y);
    }

    public void ecrire(String texte, float x, float y, Color color) {
        this.ecrire(this.batch, texte, x, y, 15.0f * FONT_MULT, color);
    }

    public void ecrire(Batch batch, String texte, float x, float y) {
        this.ecrire(batch, texte, x, y, 15.0f * FONT_MULT);
    }

    public void ecrire(Batch batch, String texte, float x, float y, Color color) {
        this.ecrire(batch, texte, x, y, 15.0f * FONT_MULT, color);
    }

    public void ecrire(Batch batch, String texte, float x, float y, float size) {
        this.ecrire(batch, texte, x, y, size, Color.WHITE);
    }

    public void ecrire(Batch batch, String texte, float x, float y, float size, Color color) {
        this.font.setColor(color);
        this.font.getData().setScale(size / 15.0f);
        float yWrite = y + size;
        this.font.draw(batch, texte, x, yWrite);
    }

    public static int getFontSize() {
        return Graphisme.getFontSize(FONT_MULT);
    }

    public static int getFontSize(float fontMult) {
        return MathUtils.ceil(15.0f * fontMult);
    }

    public void dispose() {
        this.shapeRenderer.dispose();
        this.font.dispose();
    }
}

