/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import enseeiht.kl2.tobias.Salle;
import enseeiht.kl2.tobias.SalleBoss;
import enseeiht.kl2.tobias.SalleSpawn;

public class Etage {
    private Salle[][] salles;
    private Salle actuelle;

    public Etage(int largeur, int hauteur, float worldWidth, float worldHeight) {
        this.regenerer(largeur, hauteur, worldWidth, worldHeight);
    }

    public Salle getSalleActuelle() {
        return this.actuelle;
    }

    public void setSalleActuelle(Salle.Direction direction) {
        if (this.actuelle.estCompletee()) {
            this.actuelle = this.actuelle.getSalle(direction);
            this.actuelle.genererEnnemis();
            this.actuelle.setCompletee();
        }
    }

    public void dispose() {
        Salle[][] salleArray = this.salles;
        int n = salleArray.length;
        for (int i = 0; i < n; ++i) {
            Salle[] salles;
            for (Salle salle : salles = salleArray[i]) {
                salle.dispose();
            }
        }
    }

    public void regenerer() {
        this.regenerer(this.salles[0].length, this.salles.length, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void regenerer(int largeur, int hauteur, float worldWidth, float worldHeight) {
        int l;
        int k;
        this.actuelle = new SalleSpawn(worldWidth, worldHeight);
        this.salles = new Salle[hauteur][largeur];
        int iSpawn = MathUtils.random(this.salles.length - 1);
        int jSpawn = MathUtils.random(this.salles[iSpawn].length - 1);
        for (int i = 0; i < this.salles.length; ++i) {
            for (int j = 0; j < this.salles[i].length; ++j) {
                this.salles[i][j] = i != iSpawn || j != jSpawn ? (this.salles[i][j] == null ? new Salle(worldWidth, worldHeight) : this.salles[i][j].regenerer()) : this.actuelle;
            }
        }
        do {
            k = MathUtils.random(this.salles.length - 1);
            l = MathUtils.random(this.salles[k].length - 1);
        } while (k == iSpawn && l == jSpawn);
        this.salles[k][l] = new SalleBoss(worldWidth, worldHeight);
        for (int i = 0; i < hauteur; ++i) {
            for (int j = 0; j < largeur; ++j) {
                Salle actuelle = this.salles[i][j];
                if (i > 0) {
                    actuelle.setSalle(Salle.Direction.NORD, this.salles[i - 1][j]);
                }
                if (i < hauteur - 1) {
                    actuelle.setSalle(Salle.Direction.SUD, this.salles[i + 1][j]);
                }
                if (j < largeur - 1) {
                    actuelle.setSalle(Salle.Direction.EST, this.salles[i][j + 1]);
                }
                if (j <= 0) continue;
                actuelle.setSalle(Salle.Direction.OUEST, this.salles[i][j - 1]);
            }
        }
    }
}

