/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import enseeiht.kl2.tobias.Arme;
import enseeiht.kl2.tobias.Consomable;
import enseeiht.kl2.tobias.Decor;
import enseeiht.kl2.tobias.Inventaire;
import enseeiht.kl2.tobias.Player;
import enseeiht.kl2.tobias.Potion;
import enseeiht.kl2.tobias.Utils;
import enseeiht.kl2.tobias.Vivant;

public class Coffre
extends Decor {
    private final Inventaire inventaire = new Inventaire();
    protected boolean ouvert = false;
    private static final Texture[] textures = new Texture[]{new Texture("coffre.png"), new Texture("coffre_ouvert.png")};

    public Coffre(float x, float y) {
        super(textures[0], x, y);
        boolean potion;
        this.setPosition(x, y);
        boolean stuff = MathUtils.random(1, 100) <= 25;
        boolean bl = potion = MathUtils.random(1, 100) <= (stuff ? 75 : 25);
        if (potion) {
            this.inventaire.ramasser(new Potion(MathUtils.random(1, 10) * 10));
        }
        if (stuff) {
            this.inventaire.ramasser(Arme.aleatoire());
        }
    }

    public void ouvrir(Vivant vivant) {
        if (!this.ouvert) {
            if (this.inventaire.placesUtilisees() == 0) {
                this.ajouter(new Potion(5));
            }
            Player player = Utils.player;
            player.setAttaqueHitbox(this);
            if (player.getOffensif().overlaps(this.hitbox)) {
                this.ouvert = vivant.getInventaire().ramasser(this.inventaire);
            }
        }
    }

    @Override
    public Texture getTexture() {
        return textures[this.ouvert ? 1 : 0];
    }

    public void ajouter(Consomable c) {
        if (!this.ouvert) {
            this.inventaire.ramasser(c);
        }
    }

    public boolean estOuvert() {
        return this.ouvert;
    }
}

