/*
 * Decompiled with CFR 0.152.
 */
package enseeiht.kl2.tobias;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.TimeUtils;
import enseeiht.kl2.tobias.Consomable;
import enseeiht.kl2.tobias.Utils;
import enseeiht.kl2.tobias.Vivant;

public class Arme
extends Consomable {
    public static final int DEGATS_MIN = 10;
    public static final int DEGATS_MAX = 250;
    public static final int PROTECTION_MIN = 0;
    public static final int PROTECTION_MAX = 90;
    public static final int PORTEE_MIN = 5;
    public static final int PORTEE_MAX = 20;
    private static final Array<String> texturesArmes = new Array();
    private static final Array<String> texturesArmures = new Array();
    private final int degats;
    private final int protection;
    private final Rectangle hitbox;
    private final float portee;
    private float modificateurDegats = 0.0f;
    private float modificateurProtection = 0.0f;
    private long derniereAttaque = Utils.startTime;
    private long derniereDefense = Utils.startTime;
    private Vivant proprietaire = Utils.player;
    public static Arme aucune;

    private Arme() {
        this("rouge.png", new Rectangle(0.0f, 0.0f, 32.0f, 32.0f), 10, 0, 10.0f);
    }

    public Arme(String texture, Rectangle hitbox, int degats, int protection, float portee) {
        super(new Texture(texture));
        this.hitbox = hitbox;
        this.degats = degats;
        this.protection = protection;
        this.portee = portee;
    }

    public static Arme aleatoire() {
        return Arme.aleatoire(10, 0);
    }

    public static Arme aleatoire(int degatsMin, int protectionMin) {
        return Arme.aleatoire(degatsMin, protectionMin, 250, 90);
    }

    public static Arme aleatoire(int degatsMin, int protectionMin, int degatsMax, int protectionMax) {
        Rectangle hitbox = new Rectangle(0.0f, 0.0f, 32.0f, 32.0f);
        int degats = MathUtils.random(degatsMin, degatsMax);
        int protection = MathUtils.random(protectionMin, protectionMax);
        float portee = MathUtils.random(5, 20);
        String texture = Arme.estOffensif(degats, protection) ? texturesArmes.random() : texturesArmures.random();
        return new Arme(texture, hitbox, degats, protection, portee);
    }

    public void setHitbox(Rectangle hitbox) {
        this.hitbox.set(hitbox);
    }

    public float getPortee() {
        return this.portee;
    }

    public void setHitboxCenter(Vector2 center) {
        this.hitbox.setCenter(center);
    }

    public void setModificateurDegats(float modificateurDegats) {
        this.modificateurDegats = modificateurDegats;
    }

    public void setModificateurProtection(float modificateurProtection) {
        this.modificateurProtection = modificateurProtection;
    }

    public Arme setProprietaire(Vivant proprietaire) {
        this.proprietaire = proprietaire;
        return this;
    }

    public float getDegats() {
        this.setModificateurDegats(this.proprietaire.getModificateurDegats());
        return (float)this.degats * (100.0f + this.modificateurDegats) / 100.0f;
    }

    public float getProtection() {
        this.setModificateurProtection(this.proprietaire.getModificateurProtection());
        return Math.min(99.0f, (float)this.protection + this.modificateurProtection);
    }

    public boolean overlaps(Rectangle other) {
        return this.hitbox.overlaps(other);
    }

    public boolean overlaps(Arme other) {
        return this.overlaps(other.hitbox);
    }

    public boolean overlaps(Vivant other) {
        return this.overlaps(other.getDefensif());
    }

    public float attaquer(Vivant victime) {
        float attaqueCooldown;
        if (null == victime) {
            return 0.0f;
        }
        long ecoule = TimeUtils.timeSinceMillis(this.derniereAttaque);
        if ((float)ecoule > (attaqueCooldown = 1000.0f) && this.overlaps(victime)) {
            this.derniereAttaque = TimeUtils.millis();
            return victime.reduireHP(this.getDegats());
        }
        return 0.0f;
    }

    public float parer(float degats) {
        float defenseCooldown;
        long ecoule = TimeUtils.timeSinceMillis(this.derniereDefense);
        if ((float)ecoule > (defenseCooldown = 10.0f)) {
            this.derniereDefense += ecoule;
            return degats * (100.0f - this.getProtection()) / 100.0f;
        }
        return degats;
    }

    @Override
    public void utiliser(Vivant vivant) {
        if (this.estOffensif()) {
            vivant.setOffensif(this);
        } else {
            vivant.setDefensif(this);
        }
    }

    protected String toStr() {
        return this.estOffensif() ? "+" + this.getDegats() + "_<> " + this.getPortee() : "-" + this.getProtection() + "%";
    }

    public String toString() {
        return this.toStr().replace('_', ' ');
    }

    @Override
    public String affichageInventaire() {
        return this.toStr().replace('_', '\n');
    }

    private boolean estOffensif() {
        return Arme.estOffensif(this.degats, this.protection);
    }

    private static boolean estOffensif(float degats, float protection) {
        return degats / 250.0f > protection / 90.0f;
    }

    static {
        texturesArmes.add("Lance1.png");
        texturesArmures.add("armure.png");
        aucune = new Arme(){

            @Override
            protected String toStr() {
                return "";
            }
        };
    }
}

